//
//	GSSerialMacOS.h
//	 1998, 1999, 2000 Kyle Hammond
//	hammo009@tc.umn.edu
//	Use at your own risk.  All rights reserved.  Do not distribute without permission.
//

#if !defined( __GSSerialMacOS_h_ )
#define __GSSerialMacOS_h_	1

#if !defined( __GSXSerialCommunicator_h_ )
	#include "GSXSerialCommunicator.h"
#endif
#if !defined( __OPENTRANSPORT__ )
	#include <OpenTransport.h>
#endif
#if !defined( __OSUTILS__ )
	#include <OSUtils.h>
#endif

// Here's a little bit of hocus-pocus for Universal Headers prior to 3.3.
#if !defined( UNIVERSAL_INTERFACES_VERSION ) || ( UNIVERSAL_INTERFACES_VERSION < 0x0330 )

typedef ByteCount						OTByteCount;

#define NewDeferredTaskUPP(userRoutine) 	NewDeferredTaskProc(userRoutine)
#define DisposeDeferredTaskUPP(userUPP)	DisposeRoutineDescriptor( userUPP )

typedef pascal void  (*OTNotifyProcPtr)(void *contextPtr, OTEventCode code, OTResult result, void *cookie);
typedef OTNotifyProcPtr		 			OTNotifyUPP;
#define NewOTNotifyUPP(userRoutine)		(userRoutine)
#define DisposeOTNotifyUPP(userUPP)

#endif // End hocus-pocus for earlier Universal Headers.

#define kGSSerialMacBufferSize			256

class GSSerialOT : public GSXSerialCommunicator {
public:
	// Constructor.
	explicit GSSerialOT( const GSSerialPortInfoRecord *inPortInfo, const GSXSerialPortNameRecord *inPortName ) :
				GSXSerialCommunicator( inPortInfo, inPortName, true ) { }

	virtual unsigned long	InitSerialComm( void );
	virtual unsigned long	CloseSerialComm( void );

	virtual unsigned long	SetPortOptions( const GSSerialPortInfoRecord *inPortInfo, const GSXSerialPortNameRecord *inPortName );

	virtual unsigned long	SendSerialInfo( const void *inBuffer, const unsigned long inBufferSize );
	virtual unsigned long	GetSerialInfo( void *outBuffer, unsigned long *ioCount, const long inWaitTicks );

	// Class functions.

	static short FindReadySerialPorts( GSXSerialPortNameRecordHandle *outPortInfo, const bool inOpenAndClose );

// Implementation section.
private:
	typedef struct {
		TEndpoint*		endPt;
		OSStatus			error;
		DeferredTask		receiveDataDeferredTask;
		bool				deferredTaskScheduled;
		char				inBuffer[ kGSSerialMacBufferSize ];
		unsigned char		charsInBuffer;
		bool				ready;
		bool				unbound;
		bool				disconnected;
		bool				connect;
		bool				scheduled;
		bool				optMgmtDone;
		bool				acceptDone;
		bool				passconDone;
	} SerialStateInfoOT;

	SerialStateInfoOT			mSerialInfoOT;
	TEndpointInfo				mInfo;
	OTNotifyUPP				mNotificationUPP;
	DeferredTaskUPP			mDeferredTaskUPP;

	static pascal void _class_serialEventHandler( void *contextPtr, OTEventCode code, OTResult result, void *cookie );

#if TARGET_CPU_68K
	static pascal void _class_deferredTaskProc68K( void );
#endif
	static pascal void _class_deferredTaskProc( long dtParm );

	// Can't use default constructor or copy constructor.
	GSSerialOT( );
	GSSerialOT( const GSSerialOT & );
};

#if !defined( TARGET_API_MAC_CARBON ) || ( TARGET_API_MAC_CARBON == 0 )
// Can't use Classic implementation under Carbon.

class GSSerialClassic : public GSXSerialCommunicator {
public:
	// Constructor.
	explicit GSSerialClassic( const GSSerialPortInfoRecord *inPortInfo, const GSXSerialPortNameRecord *inPortName,
				const bool inAsynchronous = true ) : GSXSerialCommunicator( inPortInfo, inPortName, inAsynchronous ) { }

	virtual unsigned long	InitSerialComm( void );
	virtual unsigned long	CloseSerialComm( void );

	virtual unsigned long	SetPortOptions( const GSSerialPortInfoRecord *inPortInfo, const GSXSerialPortNameRecord *inPortName );

	virtual unsigned long	SendSerialInfo( const void *inBuffer, const unsigned long inBufferSize );
	virtual unsigned long	GetSerialInfo( void *outBuffer, unsigned long *ioCount, const long inWaitTicks );

	// Class functions.
	static short FindReadySerialPorts( GSXSerialPortNameRecordHandle *outPortInfo, const bool inOpenAndClose = true );

// Implementation section.
private:
	friend class GSSerialMacAsyncHelper;

	short	mCharsInBuffer;
	short	mOutRefNum, mInRefNum;
	bool		mContinuousRead;
	char		mIncomingBuffer[ kGSSerialMacBufferSize ];

	// Can't use default constructor or copy constructor.
	GSSerialClassic( );
	GSSerialClassic( const GSSerialClassic & );
};

#endif	// !TARGET_API_MAC_CARBON

#endif